<?php

namespace App\Http\Controllers\Auth;

use Auth;
use App\Http\Controllers\Controller;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
use Illuminate\Foundation\Auth\SendsPasswordResetEmails;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Cache;
use App\Models\Usuario;
use App\Mail\PasswordMail;
use Illuminate\Support\Facades\Mail;

class ForgotPasswordController extends Controller
{

    use SendsPasswordResetEmails;

    public function __construct()
    {
        $this->middleware('guest');
    }

    public function recovery()
    {
        return view('login.recovery');
    }
    public function recoveryme(Request $request)
    {
        $validation = array('email' => 'required');
        $messages = array(
            'email.required' => 'Ingrese su correo electronico'
        );

        $validator = Validator::make($request->all(), $validation, $messages);

        if ($validator->fails()) 
        {
            return redirect()->back()->withErrors($validator)->withInput();
        }

        $data = Usuario::where(['email' => $request->email, 'estado' => 1])->first();

        if ($data) 
        {
            $token = $data->remember_token;

            //Codigo para enviar al correo   
            /*$objDemo = new \stdClass();
            $objDemo->codigo = $token;
            $objDemo->sender = 'Sistema de Facturacion Electronica - SEVEN';
            $objDemo->receiver = $data->nombres.' '.$data->apellidos;
            Mail::to($request->email)->send(new PasswordMail($objDemo)); */
            
            $from = "no-responder@seven.com";
            $to = $request->email;
            $subject = "Codigo de Verificacion";
            $message = "Hola <i>". $data->nombres." ".$data->apellidos."</i>,
                        <p>Le enviamos su codigo de verificacion para reestablecer su clave</p>
                        <br>
                        <b>CODIGO DE VERIFICACION : </b>
                        <div>
                        <h2><b>".$token."</b></h2>
                        </div>
                        <br>
                        <p><small>Si usted no solicito este codigo, por favor ignore este mensaje</small></p>
                        <br>
                        Atentamente:
                        <br/>
                        <i>Sistema de Facturacion Electronica - SEVEN</i>";
            $headers = "From:" . $from . "\r\n";
            $headers .= "MIME-Version: 1.0\r\n";
            $headers .= "Content-Type: text/html; charset=ISO-8859-1\r\n";
            mail($to,$subject,$message, $headers);

            return redirect()->route('reset');
            //return redirect()->back()->withSuccess('Codigo enviado');

        } 
        
        return redirect()->back()->with('flash_error', 'Este correo electronico no es valido');
    }


    public function reset()
    {
        return view('login.reset');
    }

    public function resetme(Request $request)
    {
        $validation = array('codigo' => 'required');
        $messages = array(
            'codigo.required' => 'Ingrese el codigo de verificacion'
        );

        $validator = Validator::make($request->all(), $validation, $messages);

        if ($validator->fails()) 
        {
            return redirect()->back()->withErrors($validator)->withInput();
        }

        $data = Usuario::where(['remember_token' => $request->codigo, 'estado' => 1])->first();

        if ($data) 
        {
            $token = $data->remember_token; 
            return redirect()->route('password', $token)->withInput();
        } 
        return redirect()->back()->with('flash_error', 'El codigo ingresado no es valido');
    }

    public function password($token)
    {
        $data = Usuario::where(['remember_token' => $token , 'estado' => 1])->first();
        return view('login.password', ['data'=>$data]);
    }

    public function passwordme(Request $request)
    {
        $validation = array('password' => 'required');
        $messages = array(
            'password.required' => 'Ingrese la nueva contrase単a'
        );

        $validator = Validator::make($request->all(), $validation, $messages);

        if ($validator->fails()) 
        {
            return redirect()->back()->withErrors($validator)->withInput();
        }

        $data = Usuario::where(['id_usuario' => $request->id_usuario, 'remember_token' => $request->codigo, 'estado' => 1])->first();

        if ($data) 
        {
            $data = Usuario::find($request->id_usuario);
            $data->password = bcrypt($request->password);
            $data->save();

            return redirect()->route('login');
        } 
        return redirect()->back()->with('flash_error', 'La accion nos es valida');

    }

}
