<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Auth;
use App\Models\Venta;
use App\Models\DetalleVenta;
use App\Models\GuiaRemision;
use App\Models\Local;

use App\Models\TipoComprobante;
use App\Models\TipoDocumento;
use App\Models\UnidadMedida;
use App\Models\TipoPresentacion;

use App\Models\Cliente;
use App\Models\Empresa;
use App\Models\ProductoLocal;

use App\Models\DetalleGuiaRemision;

class GuiaRemisionController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth:usuario');
    }

    public function emitir()
    {
        $res = Venta::with(['local', 'cliente', 'tipo_comprobante'])->where('id_local', Auth::guard("usuario")->user()->id_local)->where('id_nota', null)->where('id_cliente', '<>', null)->where('estado', 1)->orderBy('created_at', 'desc')->paginate(20);

        $guias = GuiaRemision::with(['venta','usuario'])->where('id_local', Auth::guard("usuario")->user()->id_local)->where('id_venta', '<>', null)->where('estado', 1)->get();  
        return view('guia.emitir', [ 'data' => $res, 'guias' => $guias ]); 
    }
    
	public function nuevo($id)
    {
	 	return view('guia.nuevo', [
            'transportista' => GuiaRemision::where('estado', 1)->groupBy('documento_transportista')->get(),
            'venta' => Venta::with(['cliente', 'tipo_comprobante'])->where(['id_venta' => $id])->first(),
            'detalle_venta' => DetalleVenta::with(['producto'])->where(['id_venta' => $id])->get(),
            'empresa' => Empresa::where(['id_empresa' => 1])->first(),
        ]); 
	}

    public function nuevo_libre()
    {
        return view('guia.nuevo_libre', [
            'transportista' => GuiaRemision::where('estado', 1)->groupBy('documento_transportista')->get(),
            'empresa' => Empresa::where(['id_empresa' => 1])->first(),
            'producto' => ProductoLocal::with(['producto'])->where('id_local', Auth::guard("usuario")->user()->id_local)->where('estado', 1)->where('stock', '>', 0)->limit(20)->get(),
        ]); 
    }

	public function listar()
	{

        $res = GuiaRemision::with(['venta','usuario', 'cliente'])->where('id_local', Auth::guard("usuario")->user()->id_local)->where('estado', 1)->where('estado_envio', '<>',null)->orderBy('created_at', 'DESC')->paginate(20);    

        return view('guia.listar', [ 'data' => $res ]); 
	}

    public function listar_guias()
    {
        $res = GuiaRemision::with(['venta','usuario', 'cliente'])->where('estado', 1)->where('estado_envio', '<>',null)->orderBy('created_at', 'DESC')->paginate(20);    
        return view('guia.listar_guias', [ 'data' => $res ]); 
    }

	public function registrar(Request $request)
    {
        if ($request->ajax())
        {    
            $id_local = Auth::guard("usuario")->user()->id_local;
            $request->request->add(['id_usuario' => Auth::guard("usuario")->user()->id_usuario]); 
            $request->request->add(['id_local' => $id_local]); 

            $correl = $this->getCorrelativo($id_local);
            $request->request->add(['serie_guia' => $correl['serie']]);
            $request->request->add(['numero_guia' => $correl['numero']]);
            $request->request->add(['nombre_guia' => $correl['nombre']]);
            $request->request->add(['id_tipo_comprobante' => 5]); // 5 tranportista | 6 remitente
            $request->request->add(['fecha_emision' => date('Y-m-d')]);
            $request->request->add(['estado_envio' => 'REGISTRADO']);
            $request->request->add(['mensaje_envio' => 'La guia fue registrada correctamente']);

            $res = GuiaRemision::create($request->all());

            if ($res) {
                //Creamos documentos XML
                $xml = new XmlController();
                $xml->crearGuia($res->id_guia_remision); 
            }
            
            $res ? $res['message'] = 'success' : $res['message'] = 'error';

            return response()->json($res); 
        }
	}


    public function registrar_libre(Request $request)
    {
        if ($request->ajax())
        {    
            $cliente= [
                'nombre' => $request->nombre, 
                'numero_documento' => $request->numero_documento, 
                'id_tipo_documento' => $request->id_tipo_documento, 
            ];

            $res0 = Cliente::create($cliente);

            if ($res0) {
                $id_local = Auth::guard("usuario")->user()->id_local;
                $request->request->add(['id_usuario' => Auth::guard("usuario")->user()->id_usuario]); 
                $request->request->add(['id_local' => $id_local]); 

                $request->request->add(['id_cliente' => $res0->id_cliente]); 

                $correl = $this->getCorrelativo($id_local);
                $request->request->add(['serie_guia' => $correl['serie']]);
                $request->request->add(['numero_guia' => $correl['numero']]);
                $request->request->add(['nombre_guia' => $correl['nombre']]);
                $request->request->add(['id_tipo_comprobante' => 5]); // 5 tranportista | 6 remitente
                $request->request->add(['fecha_emision' => date('Y-m-d')]);
                $request->request->add(['estado_envio' => 'REGISTRADO']);
                $request->request->add(['mensaje_envio' => 'La guia fue registrada correctamente']);

                $res = GuiaRemision::create($request->all());

                if ($res) {
                    //Creamos documentos XML
                    for( $i = 0; $i < count($request->id_producto); $i++)
                    {
                        $detalle= [
                            'id_guia_remision' => $res->id_guia_remision, 
                            'id_producto' => $request->id_producto[$i], 
                            'cantidad' => $request->cantidad[$i], 
                        ];

                        $res1 = DetalleGuiaRemision::create($detalle);
                    }
                    $xml = new XmlController();
                    $xml->crearGuia($res->id_guia_remision); 
                }   
                $res ? $res['message'] = 'success' : $res['message'] = 'error';
            }
            else{
                $res['message'] = 'error';
            }
            return response()->json($res); 
        }
    }


    public function getCorrelativo($id_local)
    {
        $num = GuiaRemision::where('id_local', $id_local)->max('numero_guia');

        if ($num == null) {
            $num = 0;
        }
        
        $res = Local::where(['id_local' => $id_local , 'estado' => 1])->first();
        $serie = $res->serie_guia;

        return ['numero' => $num + 1, 'serie' => $serie, 'nombre' => $serie.'-'.($num+1)];
    }

	public function detalles($id)
    {
        $venta = GuiaRemision::where(['id_guia_remision' => $id])->first();
        return view('guia.detalles', [
            'data' => GuiaRemision::with(['venta', 'usuario', 'tipo_comprobante', 'cliente'])->where(['id_guia_remision' => $id])->first(),
            'detalle_venta' => DetalleVenta::with(['producto'])->where(['id_venta' => $venta->id_venta])->get(),
            'detalle_guia' => DetalleGuiaRemision::with(['producto'])->where(['id_guia_remision' => $id])->get(),
            'empresa' => Empresa::where(['id_empresa' => 1 , 'estado' => 1])->first(),
        ]);  
    }

    public function detalles_electronico($id)
    {
        $venta = GuiaRemision::where(['id_guia_remision' => $id])->first();
        return view('guia.detalles_electronico', [
            'data' => GuiaRemision::with(['tipo_comprobante', 'venta', 'usuario', 'cliente'])->where(['id_guia_remision' => $id])->first(),
            'detalle_venta' => DetalleVenta::with(['producto'])->where(['id_venta' => $venta->id_venta])->get(),
            'detalle_guia' => DetalleGuiaRemision::with(['producto'])->where(['id_guia_remision' => $id])->get(),
            'empresa' => Empresa::where(['id_empresa' => 1 , 'estado' => 1])->first(),
        ]);  
    }

    public function buscar(Request $request)
    {
        if ($request)
        {
            $id1 = Venta::where('nombre_comprobante', 'LIKE', '%'.$request->search.'%')->first();

            $res =  GuiaRemision::with(['venta', 'usuario', 'cliente'])->where(function ($query) {
                    $query->where('estado', 1)->where('id_local', Auth::guard("usuario")->user()->id_local);
                })->where(function ($query)  use ($request, $id1) {
                    $query->where('nombre_guia', 'LIKE',  '%'.$request->search.'%')
                          ->orWhere('serie_guia', 'LIKE', '%'.$request->search.'%')
                          ->orWhere('numero_guia', 'LIKE', '%'.$request->search.'%')
                          ->orWhere('punto_llegada', 'LIKE',  '%'.$request->search.'%')
                          ->orWhere('punto_partida', 'LIKE', '%'.$request->search.'%')
                          ->orWhere('nombre_transportista', 'LIKE', '%'.$request->search.'%')
                          ->orWhere('documento_transportista', 'LIKE', '%'.$request->search.'%')
                          ->orWhere('licencia', 'LIKE', '%'.$request->search.'%')
                          ->orWhere('marca_placa', 'LIKE', '%'.$request->search.'%')
                          ->orWhere('fecha_traslado', 'LIKE', '%'.$request->search.'%')
                          ->orWhere('id_venta', '=', $id1 ? $id1->id_venta : '');
                })->paginate(10);
                
            $res->appends(['search' => $request->search]); 
            return view('guia.listar', [ 'data' => $res]); 
        }
    }

    public function buscar_venta(Request $request)
    {
        if ($request)
        {
            $id1 = Cliente::where('nombre', 'LIKE', '%'.$request->search.'%')->first();
            $id2 = Local::where('nombre', 'LIKE', '%'.$request->search.'%')->first();
            $id3 = TipoComprobante::where('nombre', 'LIKE', '%'.$request->search.'%')->first();


            $res =  Venta::with(['local', 'cliente'])->where(function ($query) {
                    $query->where('id_local', Auth::guard("usuario")->user()->id_local)->where('estado', 1)->where('id_cliente','<>', null);
                })->where(function ($query)  use ($request, $id1 ,$id2 ,$id3) {
                    $query->where('total_venta', 'LIKE',  '%'.$request->search.'%')
                          ->orWhere('tipo_pago', 'LIKE',  '%'.$request->search.'%')
                          ->orWhere('fecha_venta', 'LIKE', '%'.$request->search.'%')
                          ->orWhere('serie_comprobante', 'LIKE', '%'.$request->search.'%')
                          ->orWhere('numero_comprobante', 'LIKE', '%'.$request->search.'%')
                          ->orWhere('nombre_comprobante', 'LIKE', '%'.$request->search.'%')
                          ->orWhere('estado_envio', 'LIKE', '%'.$request->search.'%')
                          ->orWhere('id_cliente', '=', $id1 ? $id1->id_cliente : '')
                          ->orWhere('id_local', '=', $id2 ? $id2->id_local : '')
                          ->orWhere('id_tipo_comprobante', '=', $id3 ? $id3->id_tipo_comprobante : '');
                })->paginate(10);
            

            $guias = GuiaRemision::with(['venta','usuario'])->where('estado', 1)->get();  

            $res->appends(['search' => $request->search]); 
            return view('guia.emitir', [ 'data' => $res, 'guias' => $guias ]); 

        }
    }

     public function anular(Request $request)
    {
        if ($request->ajax())
        {
            $data = GuiaRemision::find($request->id_guia_remision);
            $data->estado = 0;
            $res  = $data->save();

            return response()->json($res ? ['message' => 'success'] : ['message' => 'error']);  
        }
    }

    public function estado($id)
    {
        $estado = ['ACEPTADO', 'RECHAZADO', 'NO ENVIADO', 'REGISTRADO'];

        $res = GuiaRemision::where('estado_envio', $estado[$id])->where('estado', 1)->orderBy('fecha_emision', 'desc')->paginate(10);

        return view('guia.listar_guias', [ 'data' => $res]); 

    }


    public function getByNombre(Request $request)
    {
        if ($request->ajax())
        {
            $res = null;
            if (!empty($request->search))
            {
                $res =  GuiaRemision::where(function ($query) {
                        $query->where('estado', '=', 1);
                    })->where(function ($query)  use ($request) {
                        $query->where('nombre_transportista', 'LIKE',  '%'.$request->search.'%')
                              ->orWhere('documento_transportista', 'LIKE',  '%'.$request->search.'%');
                    })->groupBy('documento_transportista')->get();
            }
            return response()->json($res); 
        }
    }





}
