<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class DetalleDelivery extends Model
{
    protected $table = 'detalle_delivery';
    protected $primaryKey = 'id_detalle_delivery';

    protected $fillable = [
        'id_detalle_delivery','id_delivery', 'id_producto', 'cantidad', 'precio', 'descuento', 'subtotal', 'estado'
    ];

    public function proforma()
    {
        return $this->belongsTo('App\Models\Delivery', 'id_delivery');
    }
    public function producto()
    {
        return $this->belongsTo('App\Models\Producto', 'id_producto');
    }
}
