<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class DetalleProforma extends Model
{
    protected $table = 'detalle_proforma';
    protected $primaryKey = 'id_detalle_proforma';

    protected $fillable = [
        'id_detalle_proforma','id_proforma', 'id_producto', 'cantidad', 'precio', 'subtotal', 'descuento', 'estado'
    ];

    public function proforma()
    {
        return $this->belongsTo('App\Models\Proforma', 'id_proforma');
    }
    public function producto()
    {
        return $this->belongsTo('App\Models\Producto', 'id_producto');
    }
}
