<?php 
 ob_start();
    header('Content-Type: text/html; charset=UTF-8');
    //require("fpdf/fpdf.php");
    require("fpdf/pdf_js.php");
    require_once("PDF417/vendor/autoload.php");
    use BigFish\PDF417\PDF417;
    use BigFish\PDF417\Renderers\ImageRenderer;
    include ("letras/NumeroALetras.php");
    include ("config.php");

    /******************************************************************************************/
    /* Funciones 
    /******************************************************************************************/
    function floattostr( $val )
    {
        preg_match( "#^([\+\-]|)([0-9]*)(\.([0-9]*?)|)(0*)$#", trim($val), $o );
        return $o[1].sprintf('%d',$o[2]).($o[3]!='.'?$o[3]:'');
    }

    /******************************************************************************************/
    /* consultas SQL
    /******************************************************************************************/
    

    $id = $_GET['id_detalle_credito'];
    $mysqli = new mysqli($db_host,$db_user,$db_pass,$db_name);

     //Para obtener datos de VENTO O PEDIDO

    $query0 = "SELECT d.* , d.created_at as hora, u.username FROM detalle_credito d INNER JOIN usuarios u ON d.id_usuario = u.id_usuario WHERE d.id_detalle_credito = '".$id."' AND d.estado = 1";
    $result0 = $mysqli->query($query0);
    $row0 = $result0->fetch_assoc();

    if (!is_null($row0['id_venta'])) {
        $query1 = "SELECT v.*, v.nombre_comprobante as comprobante, v.fecha_venta as fecha_emision, c.nombre, c.numero_documento, c.direccion, l.direccion as direc, l.telefono as telef FROM ventas v INNER JOIN clientes c ON v.id_cliente = c.id_cliente INNER JOIN local l ON v.id_local = l.id_local  WHERE id_venta = '".$row0['id_venta']."' ";
        $result1 = $mysqli->query($query1);
        $row1 = $result1->fetch_assoc();

        $DeudaInicial = number_format($row1['total_venta'], 2, '.', ''); 
        $Adelanto = 0;

        $query2 = "SELECT *  FROM detalle_credito  WHERE id_venta = '".$row0['id_venta']."' AND estado = 1 AND id_detalle_credito <>'".$id."' ";
        $result2 = $mysqli->query($query2);

        $tipo = "VENTA";


    } else {
        $query1 = "SELECT p.* , p.id_proforma as comprobante, l.direccion as direc, l.telefono as telef  FROM proformas p INNER JOIN local l ON p.id_local = l.id_local WHERE id_proforma = '".$row0['id_proforma']."' ";
        $result1 = $mysqli->query($query1);
        $row1 = $result1->fetch_assoc();

        $DeudaInicial = number_format($row1['total'], 2, '.', ''); 
        $Adelanto = number_format($row1['adelanto'], 2, '.', ''); 

        $query2 = "SELECT *  FROM detalle_credito  WHERE id_proforma= '".$row0['id_proforma']."' AND estado = 1 AND id_detalle_credito <> '".$id."' ";
        $result2 = $mysqli->query($query2);

        $tipo = "PEDIDO";
    }


    //Para obtener los datos de la empresa
    $query3 = "SELECT * FROM empresa WHERE id_empresa = '1' ";
    $result3 = $mysqli->query($query3);
    $row3 = $result3->fetch_assoc();


    // Variables correspondientes a la factura.
    $RUC        = $row1['numero_documento'];    // RUC.
    $NomRazSoc  = $row1['nombre'];              // Nombre o Razón social.
    $FecEmi     = $row0['fecha_pago'];         // Fecha de emisión.
    $Domicilio  = $row1['direccion'];           // Domicilio.
    $TotGrav    = 0;                            // Total gravado.
    $TotIGV     = 0;                            // Total IGV.
    $TotMonto   = 0;  
    //$Saldo      = $row1['saldo'];                               
    //$Adelanto   = $row1['adelanto'];                    
    $autoriza   = $row3['autorizacion'];
    $pagina     = $row3['pagina_web'];
    $empresa    = $row3['razon_social'];
   
    // TOTALES DE LA FACTURA 
    
    $sub_total = 0;
    $total = 0;
    $igv = 0;
    $desc = 0;
    $ii=0;
    $Pagado=0;


    while($row2 = $result2->fetch_assoc()){

        if ($row2['id_detalle_credito'] < $row0['id_detalle_credito']) {
            $Pagado = $Pagado + $row2['monto'];
        }
        
    }


    $TotMonto = number_format($row0['monto'], 2, '.', '');   

    /******************************************************************************************/
    /* creamos documento PDF
    /******************************************************************************************/
    
    $pdf = new PDF('P','cm', array(8,500));

    //$pdf=new PDF('P','cm','Letter');
    $pdf->AliasNbPages();
    $pdf->AddPage();
    $pdf->AddFont('IDAutomationHC39M','','IDAutomationHC39M.php');
    $pdf->AddFont('helvetica','','helvetica.php');
    $pdf->SetAutoPageBreak(true);
    $pdf->SetMargins(0, 0, 0);
    $pdf->SetLineWidth(0.02);
    $pdf->SetFillColor(0,0,0);

    //DATOS DE EMPRESA
    $pdf->image("../public/img/logo_empresa.jpg",1.6, 0.2 , 4.2, 1.5); // x , y, ancho, alto

    $pdf->SetFont('helvetica','B',8);
    $h_empresa = $pdf->GetMultiCellHeight(7, 0.31, utf8_decode($empresa) , $border=null, $align='L'); 
    $pdf->SetXY(0, 1.8);
    $pdf->MultiCell(7.6, 0.3, utf8_decode($empresa), 0, "C", 0);


    $pdf->SetFont('helvetica','',7);
    $pdf->SetXY(0,1.85 + $h_empresa);
    $pdf->Cell(7.6, 0.25, "RUC: ".$row3['ruc']."   Telf: ".$row1['telef']."", 0, 1,'C', 0);

    $pdf->SetXY(0, 2.15 + $h_empresa);
    $pdf->MultiCell(7.6, 0.25, utf8_decode($row1['direc']), 0, 'C', 0);

    $pdf->SetFont('helvetica','B',9.5);
    $pdf->SetXY(0,2.55 + $h_empresa);
    $pdf->Cell(7.6, 0.25, utf8_decode("RECIBO N° ".$row0['id_detalle_credito']), 0, 1,'C', 0);

    //DATOS DE RECIBO
    
    $pdf->SetFont('helvetica','B',7);
    $h_titu = $pdf->GetMultiCellHeight(5.1, 0.31, utf8_decode($NomRazSoc) , $border=null, $align='L'); 
    $h_domi = $pdf->GetMultiCellHeight(5.1, 0.31, utf8_decode($Domicilio) , $border=null, $align='L'); 

    $pdf->SetXY(0.2,3.2+$h_empresa);
    $pdf->Cell(1, 0.35, utf8_decode("================================================="), 0, 1,'L', 0);


    $pdf->SetXY(0.2,3.6+$h_empresa);
    $pdf->Cell(1, 0.35, utf8_decode("Cliente               : "), 0, 1,'L', 0);

    $pdf->SetXY(0.2,3.6+$h_titu+$h_domi+$h_empresa);
    $pdf->Cell(1, 0.35, utf8_decode("RUC/DNI"), 0, 1,'L', 0);

    

    $pdf->SetXY(0.22,3.6+$h_titu+$h_empresa);
    $pdf->Cell(1, 0.35, utf8_decode("Domicilio           : "), 0, 1,'L', 0);

    $pdf->SetXY(0.2,3.95+$h_titu+$h_domi+$h_empresa);
    $pdf->Cell(1, 0.35, utf8_decode("Fecha Emision"), 0, 1,'L', 0);

    $pdf->SetXY(0.2,4.31+$h_titu+$h_domi+$h_empresa);
    $pdf->Cell(1, 0.35, utf8_decode("Tipo Moneda"), 0, 1,'L', 0);

   

    $pdf->SetFont('helvetica','',7);

    $pdf->SetXY(2.4,3.6+$h_empresa);
    $pdf->MultiCell(5.1, 0.3, utf8_decode($NomRazSoc) , 0, "L", 0);

    $pdf->SetXY(2.4,3.6+$h_titu+$h_empresa);
    $pdf->MultiCell(5.1, 0.3, utf8_decode($Domicilio) , 0, "L", 0);

    $pdf->SetXY(2.1,3.6+$h_titu+$h_domi+$h_empresa);
    $pdf->Cell(1, 0.35, ":   ".utf8_decode($RUC), 0, 1,'L', 0);

    $pdf->SetXY(2.1,3.95+$h_titu+$h_domi+$h_empresa);
    $pdf->Cell(1, 0.35, ":   ".date_format(date_create($FecEmi), 'd-m-Y')."     Hora : ".date("H:i:s", strtotime($row0['hora'])), 0, 1,'L', 0);

    $pdf->SetXY(2.1,4.31+$h_titu+$h_domi+$h_empresa);
    $pdf->Cell(1, 0.35, ":   ".utf8_decode("SOL"), 0, 1,'L', 0);
     
    //DATOS DETALLE recibo

    $pdf->SetTextColor(0,0,0);
    $pdf->SetFont('helvetica','B',7);
    
    $pdf->SetXY(0.2,4.6+$h_titu+$h_domi+$h_empresa);
    $pdf->Cell(1, 0.35, utf8_decode("================================================="), 0, 1,'L', 0);

    $Y = $h_titu+$h_domi+$h_empresa;

    $pdf->SetXY(0.2,$Y+4.8);
    $pdf->Cell(1.5, 0.5, utf8_decode("Cantidad"), 0, 1,'C', 0);

    $pdf->SetXY(1.7,$Y+4.8);
    $pdf->Cell(4.5, 0.5, utf8_decode("Descripción"), 0, 1,'C', 0);

    $pdf->SetXY(6.2,$Y+4.8);
    $pdf->Cell(1.2, 0.5, utf8_decode("Importe"), 0, 1,'R', 0);

    $pdf->SetXY(0.2,$Y+5.15);
    $pdf->Cell(1, 0.35, utf8_decode("================================================="), 0, 1,'L', 0);

   
    $pdf->SetFont('helvetica','',7);
    $Y=$Y+5.6;

    $pdf->SetXY(0.2,$Y);
    $pdf->Cell(1.5, 0.35, utf8_decode("1"), 0, 1,'C', 0);

    $pdf->SetXY(1.7,$Y);
    $pdf->MultiCell(4.5, 0.35, "PAGO DE CUOTA DE DEUDA PENDIENTE DE ".$tipo.utf8_decode(" N° "). $row1['comprobante'] , 0, "L", 0);

    $pdf->SetXY(6.2,$Y);
    $pdf->Cell(1.2, 0.35,  number_format($row0['monto'],2), 0, 1,'R', 0);

    //TOTALES FACTURA
    $pdf->SetFont('helvetica','',7);

    $Y2 = $h_titu + $h_domi + $h_empresa + 6.6;

    $pdf->line(0.25, $Y2+0.2, 7.35, $Y2+0.2);

    $pdf->SetFont('helvetica','B',9);
    $pdf->SetXY(0.2,$Y2+0.4);
    $pdf->Cell(5.8, 0.35, utf8_decode("Importe Total         "), 0, 1,'R', 0);


    $pdf->SetXY(6.2,$Y2+0.4);
    $pdf->Cell(1.2, 0.35, "S/ ".number_format($row0['monto'],2), 0, 1,'R', 0);

    $pdf->line(0.25, $Y2+0.9, 7.35, $Y2+0.9);

    $pdf->SetFont('helvetica','',8);

    $pdf->SetXY(0.2, $Y2+1);
    $pdf->Cell(6, 0.35, utf8_decode("Deuda Inicial         S/ "), 0, 1,'R', 0);

    $pdf->SetXY(6.2, $Y2+1);
    $pdf->Cell(1.2, 0.35, number_format($DeudaInicial, 2), 0, 1,'R', 0);

    $pdf->SetXY(0.2, $Y2+1.5);
    $pdf->Cell(6, 0.35, utf8_decode("Nuevo Saldo         S/ "), 0, 1,'R', 0);

    $pdf->SetXY(6.2, $Y2+1.5);
    $pdf->Cell(1.2, 0.35, number_format($DeudaInicial - ($Pagado + $Adelanto) - $row0['monto'], 2), 0, 1,'R', 0);


    //Monto en LETRAS
    
    $letras = NumeroALetras::convertir($row0['monto'], 'soles', 'centimos');
    $pdf->SetFont('helvetica','BI',6.5);
    $pdf->SetXY(0.15, $Y2+2.2);
    $pdf->MultiCell(7, 0.3,"SON : ".$letras ."  SOLES" , 0, 'L');

    $h_letras = $pdf->GetMultiCellHeight(7, 0.35, $letras, $border=null, $align='L'); 



    //Observacion
    if (!is_null($row0['observacion'])) {
        $h_obser = $pdf->GetMultiCellHeight(7, 0.35, utf8_decode($row1['observacion']), $border=null, $align='L'); 
        $pdf->SetFont('helvetica','I',6.5);
        $pdf->SetXY(0.15,$Y2+$h_letras+2.4);
        $pdf->MultiCell(7, 0.35,"OBSERVACION : ".utf8_decode($row0['observacion']) , 0, 'L');
    }


    //nomnbre de usuario
    $pdf->SetFont('helvetica','BI',6.5);
    $pdf->SetXY(0,$Y2+3.2+$h_letras+$h_obser );
    $pdf->MultiCell(7, 0.35,"USUARIO : ".$row0['username'] , 0, 'L');


    //PIE DE PAGINA
    $pdf->SetFont('helvetica','B',7);
    $pdf->SetXY(0,$Y2+4+$h_letras+$h_obser );
    $pdf->MultiCell(7.5, 0.35, utf8_decode("$pagina  \n GRACIAS POR SU PREFERENCIA !!"), 0, 'C');

    //==============================================================================

    $pdf->AutoPrint(true);
    $pdf->Output();

    //unlink('image/image_hash.png');
ob_end_flush(); 