<?php 

	include("config.php");
	require_once("phpexcel/PHPExcel.php");

	if (PHP_SAPI == 'cli')
    	die('Este archivo solo se puede ver desde un navegador web');
	
	// Se crea el objeto PHPExcel
	$objPHPExcel = new PHPExcel();

	$id_local = $_GET['id_local'];
	$id_usuario = $_GET['id_usuario'];
	$tipo = $_GET['tipo'];
	$fecha1 = $_GET['fecha1'];
	$fecha2 = $_GET['fecha2'];

	$conexion = new mysqli($db_host,$db_user,$db_pass,$db_name);
	if (mysqli_connect_errno()) {
	   printf("La conexión con el servidor de base de datos falló: %s\n", mysqli_connect_error());
	   exit();
	}

	if ($tipo == 'VENTA') {
		$consulta = 'SELECT p.nombre, p.descripcion, p.precio, p.precio_mayorista, p.codigo_barras, p.fecha_vencimiento, p.situacion_impuesto, p.tipo_producto ,SUM(dv.cantidad) AS cantidad,
		CONCAT(u.nombres, " ", u.apellidos) AS usuario,
		CONCAT(l.nombre, " (", l.direccion, ")") AS local
		FROM detalle_venta dv 
		INNER JOIN productos p ON p.id_producto = dv.id_producto 
		INNER JOIN ventas v ON v.id_venta = dv.id_venta 
		INNER JOIN local l ON l.id_local = v.id_local 
		INNER JOIN usuarios u ON u.id_usuario = v.id_usuario 
		WHERE (v.created_at >= "'.$fecha1.' 00:00:00" AND v.created_at <= "'.$fecha2.' 23:59:59") 
		AND v.id_local="'.$id_local.'" 
		AND v.id_nota IS NULL 
		AND v.id_usuario = "'.$id_usuario.'" 
		AND v.estado="1" 
		GROUP BY dv.id_producto';
	}

	if ($tipo != 'VENTA') {
		$consulta = 'SELECT p.nombre, p.descripcion, p.precio, p.precio_mayorista, p.codigo_barras, p.fecha_vencimiento, p.situacion_impuesto, p.tipo_producto ,SUM(dv.cantidad) AS cantidad,
		CONCAT(u.nombres, " ", u.apellidos) AS usuario,
		CONCAT(l.nombre, " (", l.direccion, ")") AS local
		FROM detalle_proforma dv 
		INNER JOIN productos p ON p.id_producto = dv.id_producto 
		INNER JOIN proformas v ON v.id_proforma = dv.id_proforma 
		INNER JOIN local l ON l.id_local = v.id_local 
		INNER JOIN usuarios u ON u.id_usuario = v.id_usuario 
		WHERE (v.created_at >= "'.$fecha1.' 00:00:00" AND v.created_at <= "'.$fecha2.' 23:59:59") 
		AND v.id_local="'.$id_local.'" 
		AND v.id_usuario = "'.$id_usuario.'" 
		AND v.tipo = "'.$tipo.'" 
		AND v.estado="1" 
		GROUP BY dv.id_producto';
	}

$resultado = $conexion->query($consulta);

	if($resultado->num_rows > 0 ){

		// Propiedades del documento
		$objPHPExcel->getProperties()->setCreator("Seven")
									 ->setLastModifiedBy("Seven")
									 ->setTitle("Reporte de PRODUCTOS")
									 ->setSubject("Reporte de PRODUCTOS")
									 ->setDescription("Reporte de PRODUCTOS")
									 ->setKeywords("office 2010 openxml php")
									 ->setCategory("Archivo con resultado de reporte");
		
		// Combino las celdas desde A1 hasta F1
		$objPHPExcel->setActiveSheetIndex(0)->mergeCells('A1:K1');
		$objPHPExcel->setActiveSheetIndex(0)
		            ->setCellValue('A1', 'REPORTE DE PRODUCTOS DE '.$tipo.'S POR PERSONAL ENTRE : '.$fecha1.' & '.$fecha2)
		            ->setCellValue('A2', 'ITEM')
		            ->setCellValue('B2', 'NOMBRE DEL PRODUCTO')
		            ->setCellValue('C2', 'MARCA')
		            ->setCellValue('D2', 'CODIGO DE BARRAS')
		            ->setCellValue('E2', 'PRECIO VENTA UNITARIO')
		            ->setCellValue('F2', 'PRECIO VENTA POR MAYOR')
		            ->setCellValue('G2', 'FECHA DE VENCIMIENTO')
					->setCellValue('H2', 'SITUACION DE IMPUESTO')
					->setCellValue('I2', 'TIPO DE PRODUCTO')
					->setCellValue('J2', 'CANTIDAD DESPACHADA')
					->setCellValue('K2', 'PERSONAL QUE REGISTRO')
					->setCellValue('L2', 'LOCAL DONDE SE REGISTRO');
					
		// Fuente de la primera fila en negrita
		$boldArray = array('font' => array('bold' => true,),'alignment' => array('horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER));
		$objPHPExcel->getActiveSheet()->getStyle('A1:L2')->applyFromArray($boldArray);


		//Ancho de las columnas
		$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(8);	
		$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(100);	
		$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(25);	
		$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(25);	
		$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(30);	
		$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(30);	
		$objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(25);
		$objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(25);
		$objPHPExcel->getActiveSheet()->getColumnDimension('I')->setWidth(25);
        $objPHPExcel->getActiveSheet()->getColumnDimension('J')->setWidth(25);
        $objPHPExcel->getActiveSheet()->getColumnDimension('K')->setWidth(50);
        $objPHPExcel->getActiveSheet()->getColumnDimension('L')->setWidth(80);
	
		$i = 3; //Numero de fila donde se va a comenzar a rellenar
		$suma = 0;
		$j = 1;
		while ($fila = $resultado->fetch_array()) {
			$objPHPExcel->setActiveSheetIndex(0)
			    ->setCellValue('A'.$i, $j)
			    ->setCellValue('B'.$i, utf8_encode($fila['nombre']))
			    ->setCellValue('C'.$i, utf8_encode($fila['descripcion']))
			    ->setCellValue('D'.$i, $fila['codigo_barras'])
			    ->setCellValue('E'.$i, $fila['precio'])
			    ->setCellValue('F'.$i, $fila['precio_mayorista'])
			    ->setCellValue('G'.$i, $fila['fecha_vencimiento'])
			    ->setCellValue('H'.$i, utf8_encode($fila['situacion_impuesto']))
			    ->setCellValue('I'.$i, utf8_encode($fila['tipo_producto']))
			    ->setCellValue('J'.$i, $fila['cantidad'])
			    ->setCellValue('K'.$i, utf8_encode($fila['usuario']))
			    ->setCellValue('L'.$i, utf8_encode($fila['local']));
			$i++;
			$j++;
		}

		$color_style_array = [
		  'font'  => [
		    'color' => ['rgb' => 'FF0000'],
		    'bold' => true,
		  ],
		  'alignment' => [
		  	'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER
		  ]
		];

		$objPHPExcel->getActiveSheet()->getStyle('J3:J'.$i)->applyFromArray($color_style_array);
		$objPHPExcel->getActiveSheet()->getStyle('E3:E'.$i)->getNumberFormat()->setFormatCode('0.00');
		$objPHPExcel->getActiveSheet()->getStyle('F3:F'.$i)->getNumberFormat()->setFormatCode('0.00');

		$i = $i-1;
		$H = "L".$i;
		$rango = "A2:$H";
		$styleArray = array('font' => array( 'name' => 'Arial','size' => 10),
		'borders'=>array('allborders'=>array('style'=> PHPExcel_Style_Border::BORDER_THIN,'color'=>array('argb' => 'FFF')))
		);
		$objPHPExcel->getActiveSheet()->getStyle($rango)->applyFromArray($styleArray);

		// Cambiar el nombre de hoja de cálculo
		$objPHPExcel->getActiveSheet()->setTitle('Reporte de Productos');

		// Establecer índice de hoja activa a la primera hoja , por lo que Excel abre esto como la primera hoja
		$objPHPExcel->setActiveSheetIndex(0);

		// Se manda el archivo al navegador web, con el nombre que se indica, en formato 2007
		header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
		header('Content-Disposition: attachment;filename="Reporte_productos_vendidos_personal.xlsx"');
		header('Cache-Control: max-age=0');
		 
		$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
		$objWriter->save('php://output');
		exit;

	}
	else{
	    print_r('No hay resultados para mostrar');
	}



	









