$(function () {

	/******************************************************************************/
	/* start: valida formulario de ventas
	/******************************************************************************/

    $('#frmNuevo').form({
        keyboardShortcuts: false,
    	fields: {
            nombre: {
                rules: [{ type : 'empty', prompt : 'Complete este campo'}]
            },
            numero_documento: {
                rules: [
                    { type : 'integer', prompt : 'Ingrese solo números'},
                    { type : 'exactLength[11]', prompt : 'El RUC debe tener {ruleValue} digitos'}
                ]
            },

            punto_partida: {
            
                rules: [
                    { type : 'empty', prompt : 'Complete este campo'},
                    { type : 'maxLength[100]', prompt : 'La direccion es muy larga'}
                ]
            },
            punto_llegada: {
                rules: [
                    { type : 'empty', prompt : 'Complete este campo'},
                    { type : 'maxLength[100]', prompt : 'La direccion es muy larga'}
                ]

            },
            nombre_transportista: {
                rules: [{ type : 'empty', prompt : 'Complete este campo'}]
            },
            documento_transportista: {
                rules: [
                    { type : 'integer', prompt : 'Ingrese solo números'},
                    { type : 'exactLength[11]', prompt : 'El RUC debe tener {ruleValue} digitos'}
                ]
            },
            licencia: {
                rules: [
                    { type : 'integer', prompt : 'Ingrese solo números'},
                    { type : 'exactLength[8]', prompt : 'El DNI debe tener {ruleValue} digitos'},
                    { type : 'not[00000000]', prompt : 'Ingrese un DNI valido'},
                    { type : 'not[12345678]', prompt : 'Ingrese un DNI valido'},
                    { type : 'not[87654321]', prompt : 'Ingrese un DNI valido'},
                ]
            },
            marca_placa: {
                rules: [{ type : 'empty', prompt : 'Complete este campo'}]
            },
            fecha_traslado: {
                rules: [{ type : 'empty', prompt : 'Complete este campo'}]
            },
            motivo: {
                rules: [{ type : 'empty', prompt : 'Seleccione una opcion'}]
            },
            peso: {
                optional: true,
                rules: [
                    { type : 'empty', prompt : 'Complete este campo'},
                    { type   : 'regExp[/^[0-9]+([\.]{1}[0-9]+)?$/]', prompt : 'Ingrese un peso valido'},
                ]
            },

    	},
    	inline : true,
	});




    $('.btn_registrar').on('click', function() {
        var count=$("#tbody tr:first > td").length;
        if (count > 0 && ($('#total_venta') !== "")) {
            if ($('#total_venta').val() !== "") {
                if ($('#frmNuevo').form('is valid')) {
                    $('#register_modal').modal({
                        closable: false,
                        onApprove : function() {
                            sendForm();
                        }
                    }).modal('show');  
                } else {
                    $('#frmNuevo').form('validate form');
                }
            } else {
                swal("Los cantidades", "de los productos no son validas", "warning");
            }
        } else {
            swal("Por favor", "agregue algun producto a la lista", "warning");
        }
    }); 


    function sendForm() {

        var data = $('#frmNuevo').serialize();

        $.requestApi('/guia/registrar_libre', data, 'POST', function (resolve) {
            if (resolve) { 
                $.showMessagesImprimir(resolve, APP_URL+"/guia/detalles/"+resolve.id_guia_remision, APP_URL+"/../pdf/imprimeGuia.php?id_guia="+resolve.id_guia_remision);
            }
        });

        return false;
    };



    /******************************************************************************/
    /* cambiar TIPO DOCUMENTO DESTINATARIO
    /******************************************************************************/

    $('[name="id_tipo_documento"]').change(function() {

        $('#frmNuevo').form('remove prompt', ['numero_documento']);
        $('#frmNuevo').form('remove prompt', ['nombre']);

        var option= $("option:selected", this).val();
        
        if (option == "1") {
            $('input[name="numero_documento"]').attr('maxlength', 11);
            $('#frmNuevo').form('add rule', 'numero_documento', {
                rules: [
                    { type : 'integer', prompt : 'Ingrese solo números'},
                    { type : 'exactLength[11]', prompt : 'El RUC debe tener {ruleValue} digitos'}
                ]
            });
            $('#frmNuevo').form('add rule', 'nombre', {
                rules: [{ type : 'empty', prompt : 'Complete este campo'}]
            });
        }
        if (option == "2") {
            $('input[name="numero_documento"]').attr('maxlength', 8);
            $('#frmNuevo').form('add rule', 'numero_documento', {
                rules: [
                    { type : 'integer', prompt : 'Ingrese solo números'},
                    { type : 'exactLength[8]', prompt : 'El DNI debe tener {ruleValue} digitos'}
                ]
            });
            $('#frmNuevo').form('add rule', 'nombre', {
                rules: [{ type : 'empty', prompt : 'Complete este campo'}]
            });
        }
    });

    /******************************************************************************/
    /* buscar cliente con Keypress
    /******************************************************************************/

    $('body').on('click', '#nombre_transportista', function(){
        $(this).attr("readonly", false);
    });
    
    $('body').on('click', '#nombre_cliente', function(){
        $(this).attr("readonly", false);
    });


    $('#numero_documento').on('keyup', function(){
        $(this).val($(this).val().trim());
    });

/*    $('#numero_documento').on('focusout', function(){
        var num = $('#numero_documento').val();
        buscarDocumentoCliente(num);
    });*/

    $('#numero_documento').on('keypress', function(e){
        if (e.keyCode == 13){
            var num = $('#numero_documento').val();
            buscarDocumentoCliente(num);
        }   
    });

    $('#loading_doc').on('click', function() {
        var num = $('#numero_documento').val();
        buscarDocumentoCliente(num);
    });

    function buscarDocumentoCliente(num) 
    {   
        if ( $('#id_tipo_documento').val() == 1 && num.length == 11  ) // FACTURA
        {
            $("#loading_doc").addClass('loading');
            $._requestApi('/cliente/getRucByApi', {'numero_documento' : num }, 'GET', function (resolve) {
                if (resolve.nombre) {
                    $('#nombre_cliente').val(resolve.nombre);
                    $('#punto_llegada').val(resolve.direccion);
                }
                else {
                    $('#nombre_cliente').val('');
                    $('#punto_llegada').val('');
                }
                $("#loading_doc").removeClass('loading');
            }, function () {
                $("#loading_doc").removeClass('loading');
            });
        }

        if ( $('#id_tipo_documento').val() == 2  && num.length == 8 ) // BOLETA
        {
            $("#loading_doc").addClass('loading');
            $._requestApi('/cliente/getDniByApi', {'numero_documento' : num }, 'GET', function (resolve) {
                if (resolve.nombre) {
                    $('#nombre_cliente').val(resolve.nombre.trim());
                    $('#punto_llegada').val(resolve.direccion);
                }
                else {
                    $('#nombre_cliente').val('');
                    $('#punto_llegada').val('');
                }
                
                $("#loading_doc").removeClass('loading');
            }, function () {
                $("#loading_doc").removeClass('loading');
            });

        }
    }   


        /******************************************************************************/
    /* start: agrega productos a lista
    /******************************************************************************/

    $('[name="id_prod"]').dropdown({
        placeholder: 'Ingrese nombre de producto a buscar',
        direction: 'downward',
        forceSelection : false,
        fields: {
            remoteValues: 'productos',
            name: "nombre",
            value: "id_producto"
        },
        apiSettings: {
            method: 'get',
            cache: false,
            url: APP_URL + '/xml/productos/{query}',
        },

        onChange: function(value, text, $selectedItem) {
            $._requestApi('/producto_local/getById', {id_producto : value }, 'GET', function (resolve) {
                if (resolve) {
                    if (resolve.id_producto) {
                        agregarTabla(resolve);  
                        
                    }
                }   
            });
        }
    });


    /*********************************************************************************************************/
    /* modal mostrar todos los productos
    /*********************************************************************************************************/

    
    function buscarNombreProducto(producto) {
  
        $._requestApi('/producto_local/getByNombre', {'search' : producto }, 'GET', function (resolve) {
            if (resolve) {

                var datos = [];
                for( var i=0; i< resolve.length; i++ ){
                    resolve[i]['i'] = i+1;
                    if(resolve[i]){
                        datos.push(renderProductos(resolve[i]));
                    }
                }
                $('#tbody_productos').html(datos.join(''));
                
            }

            $("#btn_buscar_prod").removeClass('loading');
        });
    };

    $('.btn_buscar_producto').on('click', function() {
        $('#buscar_producto_modal').modal('show'); 
        $('#buscar_producto').val('');
        //resetearTablaProducto();
    }); 


    $('#buscar_producto').on('keypress', function(e){
        if (e.keyCode == 13){
            $("#btn_buscar_prod").addClass('loading');
            var producto = $('#buscar_producto').val();
            buscarNombreProducto(producto);
        }   
    });

    $('#btn_buscar_prod').on('click', function() {
        $("#btn_buscar_prod").addClass('loading');
        var producto = $('#buscar_producto').val();
        buscarNombreProducto(producto);
    });


    $('body').on('click', '.btn_seleccionar_producto', function(){ 
        var id = $(this).data("id");
        $("#loader_busqueda").removeClass('disabled');
        $("#loader_busqueda").addClass('active');
        $._requestApi('/producto_local/getById', {id_producto : id }, 'GET', function (resolve) {
            if (resolve) {
                if (resolve.id_producto) {
                    agregarTabla(resolve);   
                }
                $("#loader_busqueda").removeClass('active');
                $("#loader_busqueda").addClass('disabled');
                $('#buscar_producto_modal').modal('hide'); 
            }   
        });
    });




    /******************************************************************************/
    /* Consultar RUC  SUNAT clic enter
    /******************************************************************************/

    $('#documento_transportista').on('keyup', function(){
        $(this).val($(this).val().trim());
    });

    $('#documento_transportista').on('keypress', function(e){
        if (e.keyCode == 13){
            var num = $('#documento_transportista').val();
            buscarDocumentoTransportista(num);
        }   
    });

    $('#loading_doc2').on('click', function() {
        var num = $('#documento_transportista').val();
        buscarDocumentoTransportista(num);
    });

    function buscarDocumentoTransportista(num) 
    {   
        if ( num.length == 11  ) // FACTURA
        {
            $("#loading_doc2").addClass('loading');
            $._requestApi('/cliente/getRucByApi', {'numero_documento' : num }, 'GET', function (resolve) {
                if (resolve.nombre) {
                    $('#nombre_transportista').val(resolve.nombre);
                }
                else {
                    $('#nombre_transportista').val('');
                }
                $("#loading_doc2").removeClass('loading');
            }, function () {
                $("#loading_doc2").removeClass('loading');
            });
        }

    }

    /*********************************************************************************************************/
    /* modal mostrar todos los clientes
    /*********************************************************************************************************/

    function buscarNombreCliente(cliente) {
  
        $._requestApi('/guia/getByNombre', {'search' : cliente }, 'GET', function (resolve) {
            if (resolve) {
                var datos = [];
                for( var i=0; i< resolve.length; i++ ){
                    resolve[i]['i'] = i+1;
                    if(resolve[i]){
                        datos.push(renderClientes(resolve[i]));
                    }
                }
                $('#tbody_clientes').html(datos.join(''));
            }
            $("#btn_buscar_cli").removeClass('loading');
        });
    };

    $('.btn_buscar_cliente').on('click', function() {
        $('#buscar_cliente_modal').modal('show'); 
        $('#buscar_cliente').val('');
        //resetearTablaProducto();
    }); 


    $('#buscar_cliente').on('keypress', function(e){
        if (e.keyCode == 13){
            $("#btn_buscar_cli").addClass('loading');
            var cliente = $('#buscar_cliente').val();
            buscarNombreCliente(cliente);
        }   
    });

    $('#btn_buscar_cli').on('click', function() {
        $("#btn_buscar_cli").addClass('loading');
        var cliente = $('#buscar_cliente').val();
        buscarNombreCliente(cliente);
    });


    $('body').on('click', '.btn_seleccionar_cliente', function(){ 
        $("#nombre_transportista").val($(this).data("nombre"));
        $("#documento_transportista").val($(this).data("documento"));
        $("#licencia").val($(this).data("dni"));
        $("#marca_placa").val($(this).data("placa"));
        $('#buscar_cliente_modal').modal('hide'); 
    });

});


/*********************************************************************************************************/
    /* funcion agregar a tabla
    /*********************************************************************************************************/

    function agregarTabla(data) {
        if (verificaExite(data.id_producto)) {
            cant = parseFloat($('#cant'+data.id_producto).val());
            $('#cant'+data.id_producto).val(cant + 1);
            calculaSubtotal(data.id_producto);
            calcularTotal();

        } else {
            agregarFila(data);
        }
        
    }


    function agregarFila(data) {
        cant=1;
        var nuevoProducto=''+
            '<tr class="rows" id="'+data.id_producto+'">'+
                '<td><input type="hidden" name="id_producto[]" value="'+data.id_producto+'"/>'+data.producto.nombre+' '+(data.producto.descripcion !== null ? data.producto.descripcion : '')+'</td>'+
                '<td>'+data.producto.unidad_medida.nombre+'</td>'+
                '<td><input type="text" name="cantidad[]" class="cant '+data.id_producto+'" id="cant'+data.id_producto+'" value="1" size="1"></td>'+
                '<td style="display:none"><span id="v_subt'+data.id_producto+'">'+cant+'</span></td>'+
                '<td><div class="ui mini vertical animated red button" onclick="quitarTabla(this)" title="Quitar de la lista"><div class="hidden content">Quitar</div><div class="visible content"><i class="times icon"></i></div></div></td>'+
            '</tr>';
          
        $("#tbody").prepend(nuevoProducto);

        calcularTotal();

    }

/*********************************************************************************************************/
/* funciones de busqueda de productos
/*********************************************************************************************************/

$('body').on('keyup', '.cant', function(){

        $(this).val($(this).val().trim());
        var arr = $(this).attr('class').split(" ");
        calculaSubtotal(arr[1]);
        calcularTotal(); 
        
});

function verificaExite(id) {
    exist = false;
    $('#tbody tr').each(function() {
        if (this.id == id) {
            exist = true;
        }
    });

    return exist;
}


function calculaSubtotal(id) { 
    $('#v_subt'+id).text(validaNumero($('#cant'+id).val()) ? 1 : '');
}


function validaNumero(valor) {
    var expresion=/^[0-9]+([\.]{1}[0-9]+)?$/;
    return !expresion.test(valor) ? false : true; 
}

function calcularTotal() {
    var total = 0;
    $('#tbody').find('tr').each(function(index, element) {
        $(element).find('td').each(function(index1, element1) {
            if(index1==3) { //Index empieza en 0 incluye hiddens
                temp = parseFloat($(element1).text());
                total+= temp;
            }
        });
    });
    $('#total_venta').val(!isNaN(total) ? total.toFixed(2) : '');
}

function quitarTabla(elem) {
    var elementoEliminar=$(elem).parent().parent();
    $(elementoEliminar).remove();
    calcularTotal();
}


function renderClientes(resolve){
    var arr = [];
    arr = [
        '<tr>',
            '<td>',resolve.i,'</td>',
            '<td>',resolve.nombre_transportista,'</td>',
            '<td>',resolve.documento_transportista,'</td>',
            '<td>',resolve.marca_placa,'</td>',
            '<td>',resolve.licencia,'</td>',
            '<td><div class="ui mini vertical animated positive button btn_seleccionar_cliente" title="Seleccionar este cliente" data-nombre="',resolve.nombre_transportista,'" data-documento="',resolve.documento_transportista,'" data-dni="',resolve.licencia,'" data-placa="',resolve.marca_placa,'"><div class="hidden content">Elegir</div><div class="visible content"><i class="check icon"></i></div></div></td>',
        '</tr>',
    ];
    return arr.join(''); 
}

function renderProductos(resolve){
    var arr = [];
    arr = [
        '<tr data-table="'+resolve.id_producto+'">',
            '<td>',resolve.i,'</td>',
            '<td>',resolve.producto.nombre,' ',resolve.producto.descripcion,'</td>',
            '<td>',resolve.producto.unidad_medida.nombre,'</td>',
            '<td>',(resolve.stock < 1000001 ? "AGOTADO" : resolve.stock - 1000000 ),'</td>',
            '<td>',resolve.producto.precio,'</td>',
            '<td><div class="ui mini vertical animated green button btn_seleccionar_producto" title="Click para seleccionar este producto" data-id="',resolve.id_producto,'" ><div class="hidden content">Añadir</div><div class="visible content"><i class="check icon"></i></div></div></td>',
        '</tr>',
    ];
    return arr.join(''); 
}