$(function () {
    
    $('.btn_anular_deuda').on('click', function() {
        $('#update_modal').modal({
            closable: false,
            onApprove : function() {
              sendForm2();
            }
        }).modal('show');
    });
    
    function sendForm2() {

        var id_venta = $('#id_venta').val();

            $.requestApi('/venta/anular_deuda', {'id_venta' : id_venta}, 'POST', function (resolve) {
              if (resolve) {
                  $.showMessages(resolve, true, APP_URL+'/venta/detalles_deuda/'+$('#id_venta').val());
              }
        });
            
         return false;
    };

    $('.btn_cobrar_letra').on('click', function() {
      $('#pagar_letra_modal').modal('show'); 
    }); 

    $('#frmLetra').form({
      keyboardShortcuts: false,
      fields: {
        monto: {
            rules: [
              { type : 'empty', prompt : 'Complete este campo'},
              { type   : 'regExp[/^[0-9]+([\.]{1}[0-9]+)?$/]', prompt : 'Ingrese un valor valido'},
            ]
        },
      },
      inline : true,
    });

    $('.btn_registrar_letra').on('click', function() {
        if ($('#frmLetra').form('is valid')) {
            
            $('#register_modal').modal({
              closable: false,
              onApprove : function() {
                sendForm();
              }
            }).modal('show'); 
        } else {
          $('#frmLetra').form('validate form');
        }
    });

    function sendForm() {
        var data = $('#frmLetra').serialize();
          $.requestApi('/venta/registrar_letra', data, 'POST', function (resolve) {
            if (resolve) {
                $.showMessages(resolve, true, APP_URL+'/venta/detalles_deuda/'+$('#id_venta').val());
            }
        }); 
         return false;
    };



    $('.button_delete_modal').on('click', function() {

        var id = $(this).data("id"); 
    
        $('#delete_modal').modal({
            closable: false,
            onApprove : function() {
                sendDelete(id);
            }
        }).modal('show');  
    });        

    function sendDelete(id) {

        var data = {id_detalle_credito : id};

        $.requestApi('/venta/eliminar_letra', data, 'POST', function (resolve) {
            if (resolve) {
                if (resolve) {
                    $.showMessages(resolve, true, APP_URL+'/venta/detalles_deuda/'+$('#id_venta').val());  
                }
            }
        });
        
        return false;
    };   

    $('.btn_imprimir_a4').on('click', function() {
        var id = $(this).data("id");
        window.open(APP_URL+'/../pdf/imprimeReciboA4.php?id_detalle_credito='+id, '_blank');
    }); 

    $('.btn_imprimir_ticket').on('click', function() {
        var id = $(this).data("id");
        window.open(APP_URL+'/../pdf/imprimeReciboTicket.php?id_detalle_credito='+id, '_blank');
    }); 

    $('.btn_imprimir_historial').on('click', function() {
        var id = $(this).data("id");
        window.open(APP_URL+'/../pdf/imprimeHistorialTicket.php?id='+id+'&tipo=VENTA', '_blank');
    }); 




});



