$(function () {

	/******************************************************************************/
	/* start: valida formulario de ventas
	/******************************************************************************/

    $('#frmNuevo').form({
    	keyboardShortcuts: false,
    	fields: {
		    numero_documento: {
		    	depends : 'nombre',
		        rules: [
                    { type : 'integer', prompt : 'Ingrese solo números'},
                    { type : 'exactLength[8]', prompt : 'El DNI debe tener {ruleValue} digitos'}
                ]
		    },
		    nombre: {
		    	depends : 'numero_documento',
		        rules: [{ type : 'empty', prompt : 'Complete este campo'}]
		    },

    	},
    	inline : true,
	});

  	$('.btn_registrar').on('click', function() {
  		var count=$("#tbody tr:first > td").length;
    	if (count > 0 && ($('#total_venta') !== "")) {
    		if ($('#total_venta').val() !== "") {
			  	if ($('#frmNuevo').form('is valid')) {
					$('#register_modal').modal({
		  				closable: false,
				    	onApprove : function() {
				    		sendForm();
					    }
			  		}).modal('show');  
				} else {
					$('#frmNuevo').form('validate form');
				}
			} else {
				swal("Los precios", "ingresados no son validos", "warning");
			}
		} else {
			swal("Por favor", "agregue algun producto a la lista", "warning");
		}
  	});	

  	function sendForm() {

  		var data_cuotas = $('#frmCuotas').serialize(); //cuota
	    var data = $('#frmNuevo').serialize() + "&" + data_cuotas;

	   
        $.requestApi('/venta/registrar', data, 'POST', function (resolve) {
	        if (resolve) {
	            $.showMessagesImprimir(resolve, APP_URL+"/venta/detalles/"+resolve.id_venta, APP_URL+"/../pdf/imprimeTicket.php?id_venta="+resolve.id_venta);
	        }
	    });
  
        return false;
	};



	/******************************************************************************/
	/* start: muestra oculta fecha de pago al credito
	/******************************************************************************/
	$('[name="tipo_pago"]').change(function() {
		var option= $("option:selected", this).val();
		
	  	if (option == "CREDITO") {
	  		
			$('#fecha_pago').css('visibility', 'visible');
			$('#frmNuevo').form('add rule', 'fecha_pago', {
		        rules: [{ type : 'empty', prompt : 'Ingrese una fecha de pago'}]
		    });
			//Cuotas 
			$('#btn_cuotas').css('visibility', 'visible');

			//abre modal cuotas
	  		$('#cuotas_modal').modal({
	        	closable: false
	     	}).modal('show');
		  	
		} else {
			
		    $('#fecha_pago').css('visibility', 'hidden');
			$('#frmNuevo').form('remove fields', ['fecha_pago']);
			$('#frmNuevo').form('remove prompt', ['fecha_pago']);
			$('[name="fecha_pago"]').val(''); 
			//Cuotas 
			$('#btn_cuotas').css('visibility', 'hidden');
		}
	});

	/*$('[name="fecha_pago"]').on('change', function(){
		if ($('[name="fecha_pago"]').val() !== '' ) {
			$('#frmNuevo').form('remove prompt', ['fecha_pago']);
		}
	});*/ 

	/******************************************************************************/
	/* MODAL CUOTAS
	/******************************************************************************/
	$('.btn_agregar_cuotas').on('click', function() {
  		$('#cuotas_modal').modal({
        	closable: false
     	}).modal('show');

	  	$('[name="numero_cuotas"]').dropdown({
	    	forceSelection: false,
	    	autoFocus: false
  		});
  	});	

  	$('[name="numero_cuotas"]').change(function() {
		var option= $("option:selected", this).val();

		//var today = new Date();
		//var fecha = today.getFullYear()+'-'+(today.getMonth()+1)+'-'+(today.getDate()+1);


		$("#tbody_cuotas").html("");
		for (var i = 1; i <= option; i++) {

			//ojo fechas
			var currentDate = new Date();
        	currentDate.setDate(currentDate.getDate() + 30*i);
        	var fecha = $.datepicker.formatDate('yy-mm-dd', currentDate);

			agregarCuota(i, fecha);
		}
			
	  	
	});

	//boton cerrar modal cuotas

	$('#btn_cerrar_modal_cuota').on('click', function(){
		
		var fecha = $('#cuota1').val()

		console.log(fecha);

		if (fecha !== "") {
			$('#fecha_venci').val(fecha)
			$('#cuotas_modal').modal('hide');

		} else{
			swal("Ingrese", "una fecha de vencimiento", "warning");
		}		
	  	
	});

	/******************************************************************************/
	/* validacion igv de situacion impuesto
	/******************************************************************************/
	$('[name="situacion_impuesto"]').on('change', function(){
		if ($('[name="situacion_impuesto"]').val() !== 'AFECTO' ) {
			$('[name="valor_impuesto"]').val("0.00");
			$('[name="valor_impuesto"]').attr('readonly', true);
		}
		else {
			$('[name="valor_impuesto"]').val(_IGV);
			$('[name="valor_impuesto"]').attr('readonly', true);
		}
	}); 



    /*********************************************************************************************************/
	/* modal mostrar todos los productos
	/*********************************************************************************************************/

	
	function buscarNombreProducto(producto) {
  
        $._requestApi('/producto_local/getByNombre', {'search' : producto }, 'GET', function (resolve) {
	        if (resolve) {

	        	var datos = [];
                for( var i=0; i< resolve.length; i++ ){
                    resolve[i]['i'] = i+1;
                    if(resolve[i]){
                        datos.push(renderProductos(resolve[i]));
                    }
                }
                $('#tbody_productos').html(datos.join(''));
	        	
	    	}

	    	$("#btn_buscar_prod").removeClass('loading');
	    });
  	};

	$('.btn_buscar_producto').on('click', function() {
  		$('#buscar_producto_modal').modal('show'); 
  		$('#buscar_producto').val('');
  		//resetearTablaProducto();
  	});	


	$('#buscar_producto').on('keypress', function(e){
	    if (e.keyCode == 13){
	    	$("#btn_buscar_prod").addClass('loading');
	    	var producto = $('#buscar_producto').val();
    		buscarNombreProducto(producto);
    	}	
	});

	$('#btn_buscar_prod').on('click', function() {
		$("#btn_buscar_prod").addClass('loading');
    	var producto = $('#buscar_producto').val();
    	buscarNombreProducto(producto);
  	});


    $('body').on('click', '.btn_seleccionar_producto', function(){ 
    	var id = $(this).data("id");
   		var mayor = $(this).data("mayor");
    	$("#loader_busqueda").removeClass('disabled');
		$("#loader_busqueda").addClass('active');
        $._requestApi('/producto_local/getById', {id_producto : id }, 'GET', function (resolve) {
	        if (resolve) {
	        	if (resolve.id_producto) {
		        	agregarTabla(resolve, mayor);	
		        }
		        $("#loader_busqueda").removeClass('active');
				$("#loader_busqueda").addClass('disabled');
				$('#buscar_producto_modal').modal('hide'); 
	        }	
	    });
  	});


 	/*********************************************************************************************************/
	/* modal mostrar todos los clientes
	/*********************************************************************************************************/

	function buscarNombreCliente(cliente) {
  
        $._requestApi('/cliente/getByNombre', {'search' : cliente }, 'GET', function (resolve) {
	        if (resolve) {
	        	var datos = [];
                for( var i=0; i< resolve.length; i++ ){
                    resolve[i]['i'] = i+1;
                    if(resolve[i]){
                        datos.push(renderClientes(resolve[i]));
                    }
                }
                $('#tbody_clientes').html(datos.join(''));
	    	}
	    	$("#btn_buscar_cli").removeClass('loading');
	    });
  	};

	$('.btn_buscar_cliente').on('click', function() {
  		$('#buscar_cliente_modal').modal('show'); 
  		$('#buscar_cliente').val('');
  		//resetearTablaProducto();
  	});	


	$('#buscar_cliente').on('keypress', function(e){
	    if (e.keyCode == 13){
	    	$("#btn_buscar_cli").addClass('loading');
	    	var cliente = $('#buscar_cliente').val();
    		buscarNombreCliente(cliente);
    	}	
	});

	$('#btn_buscar_cli').on('click', function() {
		$("#btn_buscar_cli").addClass('loading');
    	var cliente = $('#buscar_cliente').val();
    	buscarNombreCliente(cliente);
  	});


    $('body').on('click', '.btn_seleccionar_cliente', function(){ 
		$("#numero_documento").val($(this).data("documento"));
		$("#nombre_cliente").val($(this).data("nombre"));
		$("#direccion").val($(this).data("direccion"));
		$('#buscar_cliente_modal').modal('hide'); 
  	});

	/******************************************************************************/
	/* buscar cliente con Keypress
	/******************************************************************************/

	$('#numero_documento').on('keyup', function(){
  		$(this).val($(this).val().trim());
    });

/*    $('#numero_documento').on('focusout', function(){
  		var num = $('#numero_documento').val();
    	buscarDocumentoCliente(num);
    });*/

  	$('#numero_documento').on('keypress', function(e){
	    if (e.keyCode == 13){
	    	var num = $('#numero_documento').val();
    		buscarDocumentoCliente(num);
    	}	
	});

    $('#loading_doc').on('click', function() {
    	var num = $('#numero_documento').val();
    	buscarDocumentoCliente(num);
  	});

  	function buscarDocumentoCliente(num) 
  	{	
    	if ( $('#tipo_documento').val() == 1 && num.length == 11  ) // FACTURA
    	{
    		$("#loading_doc").addClass('loading');
    		$._requestApi('/cliente/getRucByApi', {'numero_documento' : num }, 'GET', function (resolve) {
        		if (resolve.nombre) {
		        	$('#nombre_cliente').val(resolve.nombre);
		        	resolve.direccion !== '-' ? $('#direccion').val(resolve.direccion) : $('#direccion').val(' ');
		        }
		        else {
		        	$('#nombre_cliente').val('');
		        	$('#direccion').val('');
		        }
		        $("#loading_doc").removeClass('loading');
        	}, function () {
        		$("#loading_doc").removeClass('loading');
        	});
    	}

    	if ( $('#tipo_documento').val() == 2  && num.length == 8 ) // BOLETA
    	{
    		$("#loading_doc").addClass('loading');
    		$._requestApi('/cliente/getDniByApi', {'numero_documento' : num }, 'GET', function (resolve) {
        		if (resolve.nombre) {
		        	$('#nombre_cliente').val(resolve.nombre.trim());
		        	resolve.nombre.trim() !== '' ? $('#direccion').val(' ') : $('#direccion').val('');
		        }
		        else {
		        	$('#nombre_cliente').val('');
		        	$('#direccion').val('');
		        }
		        
		        $("#loading_doc").removeClass('loading');
        	}, function () {
        		$("#loading_doc").removeClass('loading');
        	});

    	}
  	}	
	/******************************************************************************/
	/* start: agrega productos a lista
	/******************************************************************************/

	$('[name="id_prod"]').dropdown({
        placeholder: 'Ingrese nombre de producto a buscar',
        direction: 'downward',
        forceSelection : false,
        fields: {
        	remoteValues: 'productos',
        	name: "nombre",
        	value: "id_producto"
        },
     	apiSettings: {
	        method: 'get',
	        cache: false,
	        url: APP_URL + '/xml/productos/{query}',
	    },

	    onChange: function(value, text, $selectedItem) {
	    	$._requestApi('/producto_local/getById', {id_producto : value }, 'GET', function (resolve) {
		        if (resolve) {
		        	if (resolve.id_producto) {
			        	agregarTabla(resolve);	
			        	
			        }
		        }	
		    });
	    }
	});
  	
  	var EventoOnKeyUpCodigoBarras;

  	$.buscarCodigoBarras = function () {	

  		$('#loading_input').addClass('loading');
  		clearTimeout(EventoOnKeyUpCodigoBarras);

  		EventoOnKeyUpCodigoBarras = setTimeout(function()
        {
  			$._requestApi('/producto_local/getByCodBarras', {codigo_barras : $("#codigo_barras").val() }, 'GET', function (resolve) {
		        if (resolve) {
		        	if (resolve.id_producto) {
			        	agregarTabla(resolve);	
			        }
			        $("#codigo_barras").val('');
			        $('#loading_input').removeClass('loading');
			       
		        }
		        	
		    });
			
		}, 200);		
  	}

	/*********************************************************************************************************/
	/* funcion agregar a tabla
	/*********************************************************************************************************/

 	function agregarTabla(data, mayor = false) {
  		if (verificaExite(data.id_producto)) {
  			cant = parseFloat($('#cant'+data.id_producto).val());
  			$('#cant'+data.id_producto).val(cant + 1);
  			calculaSubtotal(data.id_producto, data.producto.valor_impuesto);
  			desc = $('#descuento_global').val();
        	calcularTotal(desc); 

  		} else {
  			agregarFila(data, mayor);
  		}
        
  	}


  	function agregarFila(data, mayor) {
  		var precio = (mayor ? data.producto.precio_mayorista : data.producto.precio);
		var nuevoProducto=''+
            '<tr class="rows" id="'+data.id_producto+'">'+
                '<td><input type="hidden" name="id_producto[]" value="'+data.id_producto+'"/>'+data.producto.nombre+' '+(data.producto.descripcion !== null ? data.producto.descripcion : '')+'</td>'+
                '<td><input type="text" name="cantidad[]" class="cant '+data.id_producto+'" id="cant'+data.id_producto+'" value="1" size="1"></td>'+
                '<td class="warning"><input type="text" readonly class="prec '+data.id_producto+'"  name="precio_venta[]" id="prec'+data.id_producto+'" value="'+ precio +'" size="2"/></td>'+
                '<td style="display:none"><input type="hidden" name="impuesto[]" class="impu '+data.producto.valor_impuesto+'" id="impu'+data.id_producto+'" value="'+(precio-(precio/(1+(data.producto.valor_impuesto/100)))).toFixed(6)+'"/></td>'+
                '<td ><input type="text" name="descuento[]" class="desc '+data.id_producto+'" id="desc'+data.id_producto+'" value="0" size="1"></td>'+
                '<td class="positive"><input type="hidden" name="subtotal[]" id="subt'+data.id_producto+'" value="'+precio+'"/><span id="v_subt'+data.id_producto+'">'+precio+'</span></td>'+
                '<td><div class="ui mini vertical animated red button" onclick="quitarTabla(this)" title="Quitar de la lista"><div class="hidden content">Quitar</div><div class="visible content"><i class="times icon"></i></div></div></td>'+
            '</tr>';
          
        $("#tbody").append(nuevoProducto);

		desc = $('#descuento_global').val();
        calcularTotal(desc); 
  	}

  	/* CUOTAS CREDITO */
  	function agregarCuota(k, fecha) {

		var nuevaCuota=''+
            '<tr class="rows" id="'+k+'">'+
                '<td><input type="hidden" name="numero_cuota[]" value="'+k+'"/>'+k+'</td>'+
                '<td><div class="ui small input"><input type="text" class="fecha_fut2" readonly name="fecha_pago_cuota[]" id="cuota'+k+'"  value="'+fecha+'" placeholder="Fecha de vencimiento"></div></td>'+
            '</tr>';
          
        $("#tbody_cuotas").append(nuevaCuota);

        //ojo para mostrar datrepicker al hacer click
        $('.fecha_fut2').datepicker({
            dateFormat: 'yy-mm-dd', 
            changeMonth: true, 
            changeYear: true, 
            minDate: 1,
            yearRange: '-0:+10',
        });
  	}

	/*********************************************************************************************************/
	/* start: calcula precios al presionar tecla
	/*********************************************************************************************************/
	$('body').on('click', '.prec', function(){
	 	
	 	$(this).attr("readonly", false);	
	 	$(this).select();

	 	/*if (__user.id_rol==2) { // bloquea al personal de ventas cambiar el precio
	 		$(this).attr("readonly", true);	
	 		$(this).select();
	 	} else{
	 		$(this).attr("readonly", false);	
	 		$(this).select();
	 	}*/


	});  

	$('body').on('click', '.cant', function(){
	 	$(this).select();
	}); 

	$('body').on('click', '.desc', function(){
	 	$(this).select();
	}); 


	$('body').on('click', '#descuento_global', function(){
	 	this.select();
	}); 


  	$('body').on('keyup', '.cant', function(){

  		$(this).val($(this).val().trim());
    	var arr = $(this).attr('class').split(" ");
    	var imp = $('#impu'+arr[1]).attr('class').split(" ");
        calculaSubtotal(arr[1], imp[1]);
        desc = $('#descuento_global').val();
        calcularTotal(desc); 

	    
    });

    $('body').on('keyup', '.desc', function(){

    	$(this).val($(this).val().trim());
		var arr = $(this).attr('class').split(" ");
    	var imp = $('#impu'+arr[1]).attr('class').split(" ");
        calculaSubtotal(arr[1], imp[1]);
        desc = $('#descuento_global').val();
        calcularTotal(desc); 
    	
    });

    $('body').on('keyup', '.prec', function(){

    	$(this).val($(this).val().trim());
		var arr = $(this).attr('class').split(" ");
    	var imp = $('#impu'+arr[1]).attr('class').split(" ");
        calculaSubtotal(arr[1], imp[1]);
        desc = $('#descuento_global').val();
        calcularTotal(desc); 
    	
    });

    $('body').on('keyup', '#descuento_global', function(){
    	$(this).val($(this).val().trim());
    	desc = $('#descuento_global').val();
        calcularTotal(desc); 
    });



    $('body').on('keyup', '#efectivo', function(){
    	$(this).val($(this).val().trim());
        calculaVuelto( $("#total").val(), $(this).val());
    });

    $('body').on('click', '.btn_calculadora', function(){
    	$('#calculadora_modal').modal('setting', 'transition', "vertical flip").modal('show');
    	$("#total").val($("#total_venta").val());
    	$("#vuelto").val('');
    	$("#efectivo").val('');
    });

    /*********************************************************************************************************/
	/* modal agregar producto
	/*********************************************************************************************************/  	
	$('.btn_nuevo_producto').on('click', function() {
  		$('#nuevo_producto_modal').modal('show'); 
  	});	

  	$('#frmNuevoProducto').form({
  		keyboardShortcuts: false,
    	fields: {
	      	nombre: {
		        rules: [{ type : 'empty', prompt : 'Complete este campo'}]
		    },

		    precio: {
		        rules: [
			        { type : 'empty', prompt : 'Complete este campo'},
			        { type   : 'regExp[/^[0-9]+([\.]{1}[0-9]+)?$/]', prompt : 'Ingrese un valor valido'},
		        ]
		    },
		    valor_impuesto: {
		        rules: [
			        { type : 'empty', prompt : 'Complete este campo'},
			        { type   : 'regExp[/^[0-9]+([\.]{1}[0-9]+)?$/]', prompt : 'Ingrese un valor valido'},
		        ]
		    },
    	},
    	inline : true,
    });

    $('.btn_registrar_producto').on('click', function() {
		if ($('#frmNuevoProducto').form('is valid')) {
			$("#loader_producto").removeClass('disabled');
			$("#loader_producto").addClass('active');
			var data = $('#frmNuevoProducto').serialize();
	        $._requestApi('/producto/registrar_venta', data, 'POST', function (resolve) {
		        if (resolve) {
		            if (resolve.message === "success") {
		            	agregarTabla(resolve);	
		            }
		            $("#loader_producto").removeClass('active');
					$("#loader_producto").addClass('disabled');
					$('#nuevo_producto_modal').modal('hide'); 
					$.Helper.clearFields("#frmNuevoProducto", ["valor_impuesto"]); 
		        }
		    });

		} else {
			$('#frmNuevoProducto').form('validate form');
		}
  	});

});

/*********************************************************************************************************/
/* funciones de calculo
/*********************************************************************************************************/


function calculaSubtotal(id, imp) { 
	var subt = (parseFloat($('#prec'+id).val()).toFixed(6)*parseFloat($('#cant'+id).val()).toFixed(6)) - parseFloat($('#desc'+id).val()).toFixed(2);
	$('#subt'+id).val(validaNumero($('#prec'+id).val()) && validaNumero($('#cant'+id).val()) && validaNumero($('#desc'+id).val()) && (subt > 0) ? subt.toFixed(2) : '');
    $('#v_subt'+id).text(validaNumero($('#prec'+id).val()) && validaNumero($('#cant'+id).val()) && validaNumero($('#desc'+id).val()) && (subt > 0) ? subt.toFixed(2) : '');
    calculaImpuesto(id, imp);
}

function calculaImpuesto(id, v_impu) {
	var impu = parseFloat($('#subt'+id).val()).toFixed(2) - parseFloat($('#subt'+id).val()).toFixed(2)/(1+(v_impu/100));
	$('#impu'+id).val(validaNumero($('#subt'+id).val()) && !isNaN(impu) ? impu.toFixed(6) : '');
}

function calculaVuelto(total, efectivo) { 
	var vuelto = efectivo-total;
	$('#vuelto').val(validaNumero(vuelto) && validaNumero(efectivo) && (vuelto > 0) ? vuelto.toFixed(2) : '0.00');
}

function validaNumero(valor) {
    var expresion=/^[0-9]+([\.]{1}[0-9]+)?$/;
    return !expresion.test(valor) ? false : true; 
}

function verificaExite(id) {
	exist = false;
	$('#tbody tr').each(function() {
    	if (this.id == id) {
    		exist = true;
    	}
  	});

	return exist;
}

function calcularTotal(desc) {
	var total = 0;
	var igv = 0;

	$('#tbody').find('tr').each(function(index, element) {
	    $(element).find('td').each(function(index1, element1) {
	        if(index1==5) { //Index empieza en 0 incluye hiddens
	            temp = parseFloat($(element1).text());
	            total+= temp;
	        }
	    });
	});
	$('#total_venta').val((!isNaN(total)&&validaNumero(desc)&&(total-desc)>0) ? (total-desc).toFixed(2) : '');

}



function quitarTabla(elem) {
    var elementoEliminar=$(elem).parent().parent();
    $(elementoEliminar).remove();
    desc = $('#descuento_global').val();
    calcularTotal(desc); 
}

/*********************************************************************************************************/
/* funciones de busqueda de productos
/*********************************************************************************************************/

function renderProductos(resolve){
	var arr = [];
    arr = [
        '<tr data-table="'+resolve.id_producto+'">',
            '<td>',resolve.i,'</td>',
            '<td>',resolve.producto.codigo_barras,'</td>',
            '<td>',resolve.producto.nombre,' ',resolve.producto.descripcion,'</td>',
            '<td>',(resolve.stock < 1000001 ? "AGOTADO" : resolve.stock - 1000000 ),'</td>',
            '<td><div class="ui mini vertical animated positive button btn_seleccionar_producto" title="Click para seleccionar este producto" data-id="',resolve.id_producto,'" data-mayor="false"><div class="hidden content">Añadir</div><div class="visible content">',resolve.producto.precio,'</div></div></td>',
            '<td>',(resolve.producto.precio_mayorista == null  ? '' : ( resolve.producto.precio_mayorista == 0 ? '' : `<div class='ui mini vertical animated orange button btn_seleccionar_producto' title='Click para seleccionar este producto' data-id='${resolve.id_producto}' data-mayor='true'><div class='hidden content'>Añadir</div><div class='visible content'>${resolve.producto.precio_mayorista}</div></div>`)),'</td>',
        '</tr>',
    ];
    return arr.join(''); 
}

function renderClientes(resolve){
	var arr = [];
    arr = [
        '<tr data-table="'+resolve.id_cliente+'">',
            '<td>',resolve.i,'</td>',
            '<td>',resolve.nombre,'</td>',
            '<td>',resolve.tipo_documento.nombre,'</td>',
            '<td>',resolve.numero_documento,'</td>',
            '<td><div class="ui mini vertical animated positive button btn_seleccionar_cliente" title="Seleccionar este cliente" data-nombre="',resolve.nombre,'" data-documento="',resolve.numero_documento,'" data-direccion="',resolve.direccion,'"><div class="hidden content">Elegir</div><div class="visible content"><i class="check icon"></i></div></div></td>',
        '</tr>',
    ];
    return arr.join(''); 
}