@extends('layout.main')
@section('content')

    <div class="sixteen wide tablet fifteen wide computer column ">
        <div class="ui segment">
            
            <h4 class="ui dividing header teal centered">REGISTRAR NUEVA SUCURSAL</h4>
            <br>

            <form class="ui form" id="frmNuevo" autocomplete="off">
                <div class="two fields">
                    <div class="field">
                        <label>Nombre</label>
                        <div class="ui small input ">
                          <input type="text" name="nombre" maxlength="100" oninput="$.upperCase(this)">
                        </div>
                    </div>
                    <div class="field">
                        <label>Direccion</label>
                        <div class="ui small input ">
                          <input type="text" name="direccion" maxlength="100" oninput="$.upperCase(this)">
                        </div>
                    </div>
                </div>

                <div class="two fields">
                    <div class="field">
                        <label>Telefono</label>
                        <div class="ui small input ">
                          <input type="text" name="telefono"  maxlength="30">
                        </div>
                    </div>
                    <div class="field">
                        <label>Tipo</label>
                        <select class="ui small input dropdown" name="id_tipo_local">
                            <option value="">Seleccione</option>
                            @foreach($tipo_local as $tipo)
                               <option value="{{ $tipo->id_tipo_local }}"> {{ $tipo->nombre }} </option>
                            @endforeach
                        </select>  
                    </div>
                </div> 

                @if (Auth::guard("usuario")->user()->id_rol == 1)
                    <div class="two fields">
                        <div class="field">
                            <label>Serie Factura</label>
                            <div class="ui small input">
                              <input type="text" name="serie_factura" maxlength="4" oninput="$.upperCase(this)"  placeholder="FF02">
                            </div>
                        </div>
                        <div class="field">
                            <label>Serie Boleta</label>
                            <div class="ui small input">
                              <input type="text" name="serie_boleta" maxlength="4" oninput="$.upperCase(this)"  placeholder="BB02">
                            </div>
                        </div>
                    </div> 
                    <div class="two fields">
                        <div class="field">
                            <label>Serie Guia de Remision</label>
                            <div class="ui small input">
                              <input type="text" name="serie_guia" maxlength="4" oninput="$.upperCase(this)"  placeholder="TT02">
                            </div>
                        </div>
                    </div> 
                @endif

                <div class="form_footer">
                    <div class="ui right floated primary button btn_registrar"><i class="check icon"></i>REGISTRAR</div>
                </div>    
            </form>

        </div>
    </div>

    <!--start register modal -->
    <div class="ui small basic modal" id="register_modal">
        <div class="ui icon header"><i class="check circle icon"></i>Registrar Información</div>
        <div class="content" style="text-align: center; font-size: 16px">
          <p>¿Desea registrar esta información en el sistema?</p>
        </div>
        <div class="actions">
            <div class="ui red basic cancel inverted button" title="Haga clic para salir"><i class="remove icon"></i>Cancelar</div>
            <div class="ui green ok inverted button" title="Haga clic para registrar"> <i class="checkmark icon"></i>Registrar</div>
        </div>
    </div>
    <!--end register modal -->
    
@stop

@section('scripts')
    <script src="{{ asset('js/local/nuevo.js') }}"></script>
@stop


